function isAndroidPhone() {
    const ua = navigator.userAgent.toLowerCase();
    return /android/i.test(ua);
}

const iOSCallNative = (action: string, params:any = {}) => {
    return new Promise((resolve, reject) => {
        const callbackId = 'cb_' + Date.now() + '_' + Date.now();
        if (window?.webkit?.messageHandlers?.NativeBridge) {
            // 注册回调
            const callbacks = window?.nativeCallbacks;
            if (callbacks) {
                callbacks[callbackId] = resolve;
            }
            window?.webkit?.messageHandlers.NativeBridge.postMessage({
                action: action,
                params: params,
                callbackId: callbackId
            });
        } else {
            reject(new Error('Not in WKWebView'));
        }
    });
}
const androidCallNative = (action: string, params:any = {}) => {
    // 检查是否在Android WebView环境中
    return new Promise((resolve, reject) => {
        const callbackId = 'cb_' + Date.now() + '_' + Date.now();
        if (window?.AndroidInterface && typeof window?.AndroidInterface.handleMessage === 'function') {
            // 调用Android原生方法
            const callbacks = window?.nativeCallbacks;
            if (callbacks) {
                callbacks[callbackId] = resolve;
            }
            window?.AndroidInterface.handleMessage(JSON.stringify({
                action: action,
                params: params,
                callbackId: callbackId
            }));
        }else {
            reject(new Error('Not in WKWebView'));
        }
    })
}
export const callNative = (action: string, params:any = {}) => {
    if (typeof window.handleNativeCallback !== 'function') {
        window.nativeCallbacks = {};
        window.handleNativeCallback = function(callbackId: string, result: any) {
            const callbackMap = window?.nativeCallbacks;
            if (callbackMap) {
                let callback = callbackMap[callbackId];
                if (callback && typeof callback === 'function') {
                    callback(result);
                    delete callbackMap[callbackId];
                }
            }

        };
    }
    if (isAndroidPhone()) {
        return androidCallNative(action, params);
    }else {
        return iOSCallNative(action, params);
    }
}
