//
//  ViewController.swift
//  FPSElementDemo
//
//  Created by 周刚 on 2025/11/14.
//

import UIKit

class ViewController: UIViewController {
    var urlTextView: UITextView!
    var payButton: UIButton!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        // Do any additional setup after loading the view.
        // UILabel
        let label = UILabel(frame: CGRect(x: 10, y: 100, width: view.bounds.width - 20, height: 40))
        label.text = "测试链接:"
        view.addSubview(label)

        // 清空按钮
        let clearButton = UIButton(type: .custom)
        clearButton.backgroundColor = .systemOrange
        clearButton.frame = CGRect(
            x: view.bounds.width - 15 - 150,
            y: label.frame.minY,
            width: 150,
            height: 40
        )
        clearButton.layer.cornerRadius = 6
        clearButton.clipsToBounds = true
        clearButton.setTitle("清空", for: .normal)
        clearButton.addTarget(self, action: #selector(clearAction), for: .touchUpInside)
        view.addSubview(clearButton)

        // UITextView
        let textView = UITextView(frame: CGRect(
            x: 10,
            y: label.frame.maxY + 10,
            width: view.bounds.width - 20,
            height: 150
        ))
        textView.backgroundColor = .lightGray
        textView.textColor = .blue
        textView.text = "https://fps.qfpay.global/trade/v1/urltranslate/PAYCORE_SHORT_URL_202511075370911194"
        view.addSubview(textView)
        urlTextView = textView

        // 开始按钮
        let startButton = UIButton(type: .custom)
        startButton.backgroundColor = .systemBlue
        startButton.frame = CGRect(
            x: 15,
            y: textView.frame.maxY + 32,
            width: view.bounds.width - 30,
            height: 44
        )
        startButton.layer.cornerRadius = 6
        startButton.clipsToBounds = true
        startButton.setTitle("开始", for: .normal)
        startButton.addTarget(self, action: #selector(startPay(_:)), for: .touchUpInside)
        payButton = startButton
        view.addSubview(startButton)
    }
    @objc func clearAction(){
        urlTextView.text = ""
    }
    @objc func startPay(_ sender: UIButton) {
            // 实现开始支付逻辑
        invokePaymentExtension()
    }
    func showAlert() {
        let alert = UIAlertController(
            title: "没有输入参数",
            message: "请先输入FPS支付参数",
            preferredStyle: .alert
        )
        
        let okAction = UIAlertAction(title: "确定", style: .cancel, handler: nil)
        alert.addAction(okAction)
        
        present(alert, animated: true, completion: nil)
    }

    func invokePaymentExtension() {
        // 1. 获取支付参数（从输入框中读取）
        guard let paymentRequestURL = urlTextView.text, !paymentRequestURL.isEmpty else {
            showAlert()
            return
        }

        // 商户的Universal Link（用于支付完成后回调商户App）可参数Apple开发文档 https://developer.apple.com/documentation/xcode/supporting-universal-links-in-your-app
        let callbackURL = "https://img-int.qfapi.com/trade/123"; //

        // 2. 封装数据为字典
        let paymentPayload: [String: String] = [
            "URL": paymentRequestURL,
            "callback": callbackURL
        ]

        // 3. 创建 NSItemProvider（注意：需使用 NSCoding 兼容类型，Dictionary 需转为 NSDictionary）
        let itemProvider = NSItemProvider(
            item: paymentPayload as NSDictionary,
            typeIdentifier: "hk.com.hkicl"
        )

        // 4. 创建 NSExtensionItem 并添加附件
        let extensionItem = NSExtensionItem()
        extensionItem.attachments = [itemProvider]

        // 5. 初始化 UIActivityViewController
        let activityVC = UIActivityViewController(
            activityItems: [extensionItem],
            applicationActivities: nil
        )

        // 6. 适配 iPad（必须设置 popover）
        if UIDevice.current.userInterfaceIdiom == .pad {
            activityVC.popoverPresentationController?.sourceView = self.view
            activityVC.popoverPresentationController?.sourceRect = payButton.frame
            activityVC.popoverPresentationController?.permittedArrowDirections = .up
        }

        // 7. 设置完成回调
        activityVC.completionWithItemsHandler = { [weak self] (activityType, completed, returnedItems, error) in
            if completed {
                print("用户选择了扩展：\(activityType?.rawValue ?? "unknown")，处理完成")
                // 可在此解析 returnedItems（如果扩展返回了数据）
            } else if let error = error {
                print("扩展调用失败：\(error.localizedDescription)")
            } else {
                print("用户取消了操作")
            }
        }

        // 8. 展示应用选择器
        present(activityVC, animated: true, completion: nil)
    }

}

