//
//  FPSWKWebView.swift
//  FPSElementDemo
//
//  Created by 周刚 on 2025/11/19.
//

@preconcurrency import WebKit
import UIKit
class FPSWKWebView: WKWebView{
    
    private var callbackId: String?
    
    init(frame: CGRect) {
        let userContentController = WKUserContentController()
        
        // 2. 配置 WebView
        let configuration = WKWebViewConfiguration()
        configuration.userContentController = userContentController
        configuration.processPool = WKProcessPool()
        configuration.preferences.javaScriptCanOpenWindowsAutomatically = true
        
        super.init(frame: frame, configuration: configuration)
        userContentController.add(self, name: "NativeBridge")
        
        navigationDelegate = self
        uiDelegate = self
        
        if #available(iOS 16.4, *){
            isInspectable = true
        }
        NotificationCenter.default.addObserver(self, selector: #selector(fpsPaymentResult(_:)), name: Notification.Name.init(rawValue: "kNotificationNameFPSPaymentH5CallAppResult"), object: nil)
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    // MARK: - 支付结果处理（接收来自 FPSAppCallAppTool 的通知）
    @objc private func fpsPaymentResult(_ notification: Notification) {
        guard let paramsDict = notification.object as? [String: Any],
              let isSuccess = paramsDict["is_successful"] as? String else {
            return
        }
        
        // 构造返回给 JS 的结果
        let result: [String: String] = Int(isSuccess) == 0 ? [
            "code": "3000",
            "respmsg": "Failed"
        ] : [
            "code": "0000",
            "respmsg": "Success"
        ]
        
        // 序列化为 JSON 字符串
        guard let jsonData = try? JSONSerialization.data(withJSONObject: result, options: []),
              let jsonString = String(data: jsonData, encoding: .utf8) else {
            print("❌ JSON 序列化失败")
            return
        }
        
        // 构造 JS 调用代码：window.handleNativeCallback('callbackId', '{"code":"0000",...}')
        guard let callbackId = callbackId else {
            print("⚠️ 无有效的 callbackId，无法回调 JS")
            return
        }
        
        let jsCode = "window.handleNativeCallback('\(callbackId)', '\(jsonString)');"
        
        // 执行 JS
        evaluateJavaScript(jsCode) { result, error in
            if let error = error {
                print("❌ JS 注入失败: \(error)")
            } else {
                print("✅ JS 回调注入成功")
            }
        }
    }
    
    // MARK: 获取rootVC
    func getCurrentWindowRootVC() -> UIViewController? {
        for scene in UIApplication.shared.connectedScenes {
            guard let windowScene = scene as? UIWindowScene else { continue }
            for window in windowScene.windows where window.isKeyWindow {
                return window.rootViewController
            }
        }
        return nil
    }
    deinit{
        NotificationCenter.default.removeObserver(self)
    }
}
extension FPSWKWebView: WKScriptMessageHandler{
    // MARK: WKScriptMessageHandler
    func userContentController(_ userContentController: WKUserContentController, didReceive message: WKScriptMessage) {
        guard message.name == "NativeBridge",
            let body = message.body as? [String: Any] else {
            return
        }
               
        guard let action = body["action"] as? String else { return }

        if action == "FPSH5CallApp" {
           // 提取参数
           guard let params = body["params"] as? [String: Any],
                 let paymentRequestURL = params["paymentRequestURL"] as? String else {
               return
           }
           
           // 保存回调 ID（由 JS 传入）
           callbackId = body["callbackId"] as? String
           
           // 调起支付扩展
           FPSAppCallAppTool.shared.invokePaymentExtension(paymentRequestURL: paymentRequestURL)
        }
    }
}
extension FPSWKWebView: WKUIDelegate{
    func webView(
            _ webView: WKWebView,
            runJavaScriptAlertPanelWithMessage message: String,
            initiatedByFrame frame: WKFrameInfo,
            completionHandler: @escaping () -> Void
        ) {
            let alert = UIAlertController(title: "提示", message: message, preferredStyle: .alert)
            alert.addAction(UIAlertAction(title: "确定", style: .default) { _ in
                completionHandler() // ⚠️ 必须调用！否则 JS 阻塞
            })

            // 获取当前顶层 ViewController 并弹出
            if let topVC = getCurrentWindowRootVC() {
                topVC.present(alert, animated: true)
            } else {
                // 安全兜底：避免 JS 卡死
                completionHandler()
            }
        }
}
extension FPSWKWebView: WKNavigationDelegate{
    // MARK: WKNavigationDelegate
    func webView(_ webView: WKWebView, didStartProvisionalNavigation navigation: WKNavigation!) {
        print("监听页面开始加载...");
    }
    func webView(_ webView: WKWebView, didFinish navigation: WKNavigation!) {
        print("✅ 页面加载成功: %@", webView.url as Any);
    }
    func webView(_ webView: WKWebView, didFail navigation: WKNavigation!, withError error: any Error) {
        print("❌ 导航失败: %@", error.localizedDescription);
    }
    func webView(_ webView: WKWebView, didFailProvisionalNavigation navigation: WKNavigation!, withError error: any Error) {
        print("❌ 页面加载失败（如 DNS、SSL、网络问题）: %@", error.localizedDescription);
        print("错误详情: %@", error);
    }
}
