//
//  FPSAppCallAppTool.swift
//  FPSElementDemo
//
//  Created by 周刚 on 2025/11/19.
//

import Foundation
import UIKit
class FPSAppCallAppTool:NSObject{
    static let shared = FPSAppCallAppTool()
    
    func fpsPaymentResult(_ result: [String: Any]) {
        print(result)
        NotificationCenter.default.post(name: NSNotification.Name.init("kNotificationNameFPSPaymentH5CallAppResult"), object: result)
    }
    
    func invokePaymentExtension(paymentRequestURL: String?) {
        // 1. 获取支付参数（从输入框中读取）
        guard let paymentRequestURL = paymentRequestURL, !paymentRequestURL.isEmpty else {
                showAlert()
                return
        }

        // 商户的Universal Link（用于支付完成后回调商户App）可参数Apple开发文档 https://developer.apple.com/documentation/xcode/supporting-universal-links-in-your-app
        let callbackURL = "https://img-int.qfapi.com/trade/123"; //

        // 2. 封装数据为字典
        let paymentPayload: [String: String] = [
            "URL": paymentRequestURL,
            "callback": callbackURL
        ]

        // 3. 创建 NSItemProvider（注意：需使用 NSCoding 兼容类型，Dictionary 需转为 NSDictionary）
        let itemProvider = NSItemProvider(
            item: paymentPayload as NSDictionary,
            typeIdentifier: "hk.com.hkicl"
        )

        // 4. 创建 NSExtensionItem 并添加附件
        let extensionItem = NSExtensionItem()
        extensionItem.attachments = [itemProvider]

        // 5. 初始化 UIActivityViewController
        let activityVC = UIActivityViewController(
            activityItems: [extensionItem],
            applicationActivities: nil
        )

        // 6. 适配 iPad（必须设置 popover）
        if UIDevice.current.userInterfaceIdiom == .pad,
            let rootVC = getCurrentWindowRootVC() {
            activityVC.popoverPresentationController?.sourceView = rootVC.view
            activityVC.popoverPresentationController?.sourceRect = rootVC.view.bounds
            activityVC.popoverPresentationController?.permittedArrowDirections = .up
        }

        // 7. 设置完成回调
        activityVC.completionWithItemsHandler = { [weak self] (activityType, completed, returnedItems, error) in
            if completed {
                print("用户选择了扩展：\(activityType?.rawValue ?? "unknown")，处理完成")
                // 可在此解析 returnedItems（如果扩展返回了数据）
            } else if let error = error {
                print("扩展调用失败：\(error.localizedDescription)")
            } else {
                print("用户取消了操作")
            }
        }

        // 8. 展示应用选择器
        if let rootVC = getCurrentWindowRootVC() {
            rootVC.present(activityVC, animated: true, completion: nil)
        } else {
            showAlert(message: "无法获取当前界面，无法启动支付")
        }
    }
    
    private func getCurrentWindowRootVC() -> UIViewController? {
        for scene in UIApplication.shared.connectedScenes {
            guard let windowScene = scene as? UIWindowScene else { continue }
            for window in windowScene.windows where window.isKeyWindow {
                return window.rootViewController
            }
        }
        return nil
    }
    
    private func showAlert(title: String = "没有输入参数",
                               message: String = "请先输入FPS支付参数") {
        let alert = UIAlertController(title: title, message: message, preferredStyle: .alert)
        alert.addAction(UIAlertAction(title: "确定", style: .cancel))

        if let rootVC = getCurrentWindowRootVC() {
            rootVC.present(alert, animated: true)
        }
    }
    
    func parseQueryParamsFromCallbackURL(_ url: URL) {
        guard let components = URLComponents(url: url, resolvingAgainstBaseURL: false),
              let queryItems = components.queryItems else {
            return
        }
        
        var params: [String: String] = [:]
        for item in queryItems {
            if let value = item.value {
                params[item.name] = value
            }
        }
        
        fpsPaymentResult(params)
    }
}
