//
//  BashViewController.swift
//  FPSElementDemo
//
//  Created by 周刚 on 2025/11/19.
//

import UIKit

class BashViewController: UIViewController {
    override func viewDidLoad() {
        super.viewDidLoad()
        title = "FPS Demo"
        view.backgroundColor = .white
        
        // 原生触发支付按钮
        let appCallButton = UIButton(type: .custom)
        appCallButton.backgroundColor = .systemBlue
        appCallButton.frame = CGRect(x: 30, y: 200, width: 150, height: 150)
        appCallButton.layer.cornerRadius = 75
        appCallButton.layer.masksToBounds = true
        appCallButton.setTitle("原生触发支付", for: .normal)
        appCallButton.addTarget(self, action: #selector(appCallAction), for: .touchUpInside)
        view.addSubview(appCallButton)
        
        // H5 触发支付按钮
                let h5CallButton = UIButton(type: .custom)
                h5CallButton.backgroundColor = .systemBlue
                h5CallButton.frame = CGRect(
                    x: view.bounds.width - 30 - 150,
                    y: 200,
                    width: 150,
                    height: 150
                )
                h5CallButton.layer.cornerRadius = 75
                h5CallButton.layer.masksToBounds = true
                h5CallButton.setTitle("H5触发支付", for: .normal)
                h5CallButton.addTarget(self, action: #selector(h5CallAction), for: .touchUpInside)
                view.addSubview(h5CallButton)
    }
    @objc func appCallAction() {
           let callVC = AppCallViewController()
           navigationController?.pushViewController(callVC, animated: true)
    }
    @objc func h5CallAction() {
           let callVC = H5CallViewController()
           navigationController?.pushViewController(callVC, animated: true)
    }
}
