//
//  AppCallViewController.swift
//  FPSElementDemo
//
//  Created by 周刚 on 2025/11/19.
//

import UIKit

class AppCallViewController: UIViewController {
    var urlTextView: UITextView!
    var payButton: UIButton!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        // Do any additional setup after loading the view.
        // UILabel
        view.backgroundColor = .white
        
        let label = UILabel(frame: CGRect(x: 10, y: 100, width: view.bounds.width - 20, height: 40))
        label.text = "测试链接:"
        view.addSubview(label)

        // 清空按钮
        let clearButton = UIButton(type: .custom)
        clearButton.backgroundColor = .systemOrange
        clearButton.frame = CGRect(
            x: view.bounds.width - 15 - 150,
            y: label.frame.minY,
            width: 150,
            height: 40
        )
        clearButton.layer.cornerRadius = 6
        clearButton.clipsToBounds = true
        clearButton.setTitle("清空", for: .normal)
        clearButton.addTarget(self, action: #selector(clearAction), for: .touchUpInside)
        view.addSubview(clearButton)

        // UITextView
        let textView = UITextView(frame: CGRect(
            x: 10,
            y: label.frame.maxY + 10,
            width: view.bounds.width - 20,
            height: 150
        ))
        textView.backgroundColor = .lightGray
        textView.textColor = .blue
        textView.text = "https://fps.qfpay.global/trade/v1/urltranslate/PAYCORE_SHORT_URL_202511075370911194"
        view.addSubview(textView)
        urlTextView = textView

        // 开始按钮
        let startButton = UIButton(type: .custom)
        startButton.backgroundColor = .systemBlue
        startButton.frame = CGRect(
            x: 15,
            y: textView.frame.maxY + 32,
            width: view.bounds.width - 30,
            height: 44
        )
        startButton.layer.cornerRadius = 6
        startButton.clipsToBounds = true
        startButton.setTitle("开始", for: .normal)
        startButton.addTarget(self, action: #selector(startPay(_:)), for: .touchUpInside)
        payButton = startButton
        view.addSubview(startButton)
        
        NotificationCenter.default.addObserver(self, selector: #selector(fpsPaymentResult(_:)), name: Notification.Name.init(rawValue: "kNotificationNameFPSPaymentH5CallAppResult"), object: nil)
        
    }
    
    @objc func fpsPaymentResult(_ notification: Notification){
        guard let paramsDict = notification.object as? [String: String],
                  let ret = paramsDict["is_successful"] else {
                return
        }
        
        let message: String
        if Int(ret) == 0 {
            message = "支付失败"
        } else {
            message = "支付成功"
        }
        
        let alert = UIAlertController(title: "提示", message: message, preferredStyle: .alert)
        alert.addAction(UIAlertAction(title: "确定", style: .default))
        
        present(alert, animated: true)
    }
    @objc private func clearAction(){
        urlTextView.text = ""
    }
    @objc private func startPay(_ sender: UIButton) {
            // 实现开始支付逻辑
        FPSAppCallAppTool.shared.invokePaymentExtension(paymentRequestURL: urlTextView.text)
    }
    deinit{
        NotificationCenter.default.removeObserver(self)
    }
}
