//
//  FPSWKWebView.m
//  FPSElement
//
//  Created by 周刚 on 2025/11/19.
//

#import "FPSWKWebView.h"
#import <WebKit/WebKit.h>
#import "FPSAppCallAppTool.h"
#import "define.h"
@interface FPSWKWebView ()<WKScriptMessageHandler, WKNavigationDelegate, WKUIDelegate>
@property(copy, nonatomic) NSString *callbackId;
@end

@implementation FPSWKWebView
- (instancetype)initWithFrame:(CGRect)frame{
    WKUserContentController *userContentController = [[WKUserContentController alloc] init];
    [userContentController addScriptMessageHandler:self name:@"NativeBridge"]; // 注册名为 "NativeBridge" 的通道
    
    WKWebViewConfiguration *config = [[WKWebViewConfiguration alloc] init];
    // web内容处理池
    config.processPool = [[WKProcessPool alloc] init];
    config.userContentController = userContentController;
    // 在iOS上默认为NO，表示不能自动通过窗口打开
    config.preferences.javaScriptCanOpenWindowsAutomatically = YES;
    //    config.preferences.javaScriptEnabled = YES;
    [config.preferences setValue:@YES forKey:@"allowFileAccessFromFileURLs"];
    
    self = [super initWithFrame:frame configuration:config];
    if (self) {
        self.autoresizingMask = UIViewAutoresizingFlexibleWidth | UIViewAutoresizingFlexibleHeight;
        self.navigationDelegate = self;
        self.UIDelegate = self;
        if (@available(iOS 16.4, *)) {
            self.inspectable = YES;
        }
        [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(fpsPaymentResult:) name:kNotificationNameFPSPaymentH5CallAppResult object:nil];
    }
    return self;
}
- (void)fpsPaymentResult:(NSNotification *)notification {
    NSLog(@"%@", notification.object);
    NSDictionary *params = nil;
    NSString *ret = notification.object[@"is_successful"];
    if ([ret isEqualToString: @"0"]) {
        params = @{
            @"code": @"3000",
            @"respmsg": @"Failed",
        };
    }else{
        params = @{
            @"code": @"0000",
            @"respmsg": @"Success",
        };
    }
    
    // 将 userInfo 转为 JSON 字符串，再拼成 JS 函数调用
    NSError *error;
    NSData *jsonData = [NSJSONSerialization dataWithJSONObject:params options:0 error:&error];
    if (error) {
        NSLog(@"JSON 序列化失败: %@", error);
        return;
    }
    NSString *jsonString = [[NSString alloc] initWithData:jsonData encoding:NSUTF8StringEncoding];
    
    // 构造 JS 代码
    NSString *jsCode = [NSString stringWithFormat:@"window.handleNativeCallback('%@', '%@');", self.callbackId, jsonString];
    
    // 主动调用 JS 回调
    [self evaluateJavaScript:jsCode completionHandler:^(id _Nullable result, NSError * _Nullable error) {
        if (error) {
            NSLog(@"❌❌❌❌❌JS 注入失败: %@", error);
        } else {
            NSLog(@"✅✅✅✅✅✅ JS 注入成功");
        }
    }];
}
#pragma mark - WKScriptMessageHandler
// 处理 JS 发来的消息
- (void)userContentController:(WKUserContentController *)userContentController
      didReceiveScriptMessage:(WKScriptMessage *)message {
    
    if ([message.name isEqualToString:@"NativeBridge"]) {
        NSDictionary *body = message.body;
        
        // 假设 JS 传了 { action: "getUserInfo", callback: "callback_123" }
        NSString *action = body[@"action"];
        NSString *callbackId = body[@"callbackId"]; // 回调函数名
        if ([action isEqualToString:@"FPSH5CallApp"]) {
            // 模拟原生数据
            NSString *paymentRequestURL = body[@"params"][@"paymentRequestURL"];
            self.callbackId = callbackId;
            [[FPSAppCallAppTool shareInstance] invokePaymentExtension:paymentRequestURL];
        }
    }
}
- (UIViewController *)getCurrentWindowRootVC {
    for (UIScene *scene in [UIApplication sharedApplication].connectedScenes) {
        if ([scene isKindOfClass:[UIWindowScene class]]) {
            UIWindowScene *windowScene = (UIWindowScene *)scene;
            for (UIWindow *window in windowScene.windows) {
                if (window.isKeyWindow) {
                    return window.rootViewController;
                }
            }
        }
    }
    return nil;
}

#pragma mark - WKUIDelegate
- (void)webView:(WKWebView *)webView runJavaScriptAlertPanelWithMessage:(nonnull NSString *)message initiatedByFrame:(nonnull WKFrameInfo *)frame completionHandler:(nonnull WK_SWIFT_UI_ACTOR void (^)(void))completionHandler{
    NSLog(@"%@", message);
    UIAlertController *alert = [UIAlertController alertControllerWithTitle:@"提示"
                                                                       message:message
                                                                preferredStyle:UIAlertControllerStyleAlert];
    [alert addAction:[UIAlertAction actionWithTitle:@"确定"
                                               style:UIAlertActionStyleDefault
                                             handler:^(UIAlertAction * _Nonnull action) {
        completionHandler(); // 必须调用，否则 JS 会卡住
    }]];
    
    [[self getCurrentWindowRootVC] presentViewController:alert animated:YES completion:nil];
}
#pragma mark - WKNavigationDelegate
- (void)webView:(WKWebView *)webView didStartProvisionalNavigation:(WKNavigation *)navigation {
    NSLog(@"监听页面开始加载...");
}

- (void)webView:(WKWebView *)webView didFinishNavigation:(WKNavigation *)navigation {
    NSLog(@"✅ 页面加载成功: %@", webView.URL);
    // 注入回调处理函数到 JS 全局作用域
//    NSString *setupJS = @"if (typeof window.handleNativeCallback !== 'function') {"
//        @"window.nativeCallbacks = {};"
//        @"window.handleNativeCallback = function(callbackId, result) {"
//            @"var callback = window.nativeCallbacks[callbackId];"
//            @"if (callback && typeof callback === 'function') {"
//                @"callback(result);"
//                @"delete window.nativeCallbacks[callbackId];"
//            @"}"
//        @"};"
//        @"void(0);"   // ← 关键！强制返回 undefined
//        @"}";
//    [self evaluateJavaScript:setupJS completionHandler:^(id _Nullable result, NSError * _Nullable error) {
//        if (error) {
//            NSLog(@"❌ JS 注入失败: %@", error);
//        } else {
//            NSLog(@"✅ JS 注入成功");
//        }
//    }];
}

- (void)webView:(WKWebView *)webView didFailNavigation:(WKNavigation *)navigation withError:(NSError *)error {
    NSLog(@"❌ 导航失败: %@", error.localizedDescription);
}

- (void)webView:(WKWebView *)webView didFailProvisionalNavigation:(WKNavigation *)navigation withError:(NSError *)error {
    NSLog(@"❌ 页面加载失败（如 DNS、SSL、网络问题）: %@", error.localizedDescription);
    NSLog(@"错误详情: %@", error);
}

- (void)dealloc {
    // 移除 handler，防止内存泄漏
    [self.configuration.userContentController removeScriptMessageHandlerForName:@"NativeBridge"];
    [[NSNotificationCenter defaultCenter] removeObserver:self name:kNotificationNameFPSPaymentH5CallAppResult object:nil];
}


@end
