//
//  FPSAppCallAppTool.m
//  FPSElement
//
//  Created by 周刚 on 2025/11/19.
//

#import "FPSAppCallAppTool.h"
#import <UIKit/UIKit.h>
#import "define.h"
@implementation FPSAppCallAppTool

+ (FPSAppCallAppTool *)shareInstance {
    static FPSAppCallAppTool *model = nil;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        if (!model) {
            model = [[FPSAppCallAppTool alloc] init];
        
        }
    });
    return model;
}
- (void)fpsPaymentResult:(NSDictionary *) result {
    NSLog(@"%@", result);
    [[NSNotificationCenter defaultCenter] postNotificationName:kNotificationNameFPSPaymentH5CallAppResult object:result];
}
- (UIViewController *)getCurrentWindowRootVC {
    for (UIScene *scene in [UIApplication sharedApplication].connectedScenes) {
        if ([scene isKindOfClass:[UIWindowScene class]]) {
            UIWindowScene *windowScene = (UIWindowScene *)scene;
            for (UIWindow *window in windowScene.windows) {
                if (window.isKeyWindow) {
                    return window.rootViewController;
                }
            }
        }
    }
    return nil;
}
- (void)invokePaymentExtension:(NSString *)paymentRequestURL {
    // 1. 获取支付参数（从商户服务器获取如https://fps.qfpay.global/trade/v1/urltranslate/PAYCORE_SHORT_URL_202511075370911194）
    // Demo测试可在输入框中输入响应的支付参数
    @try {
        if (!paymentRequestURL || paymentRequestURL.length <= 0) {
            [self showAlert];
            return;
        }
    } @catch (NSException *exception) {
        return;
    }
    // 商户的Universal Link（用于支付完成后回调商户App）可参数Apple开发文档 https://developer.apple.com/documentation/xcode/supporting-universal-links-in-your-app
    NSString *callbackURL = @"https://img-int.qfapi.com/trade/123"; //
    
    // 2. 封装数据为字典（包含URL和callback）
    NSDictionary *paymentPayload = @{
        @"URL": paymentRequestURL,
        @"callback": callbackURL
    };
        
    NSItemProvider *itemProvider = [[NSItemProvider alloc]
            initWithItem:paymentPayload
            typeIdentifier:@"hk.com.hkicl"];
    
    // 4. 创建NSExtensionItem并添加附件
    NSExtensionItem *extensionItem = [[NSExtensionItem alloc] init];
    extensionItem.attachments = @[itemProvider];
    
    // 5. 初始化UIActivityViewController（系统应用选择器）
    UIActivityViewController *activityVC = [[UIActivityViewController alloc]
                                            initWithActivityItems:@[extensionItem]
                                            applicationActivities:nil];
    
    // 6. 适配iPad（必须指定弹出位置，否则崩溃）
    if ([[UIDevice currentDevice] userInterfaceIdiom] == UIUserInterfaceIdiomPad) {
        activityVC.popoverPresentationController.sourceView = [self getCurrentWindowRootVC].view;
        activityVC.popoverPresentationController.sourceRect = [self getCurrentWindowRootVC].view.frame; // 从按钮位置弹出
        activityVC.popoverPresentationController.permittedArrowDirections = UIPopoverArrowDirectionUp;
    }
    
    // 7. 处理扩展返回的临时结果（非最终支付结果，仅作参考）
    activityVC.completionWithItemsHandler = ^(UIActivityType  _Nullable activityType,
                                              BOOL completed,
                                              NSArray * _Nullable returnedItems,
                                              NSError * _Nullable error) {
        if (completed) {
            NSLog(@"用户选择了扩展：%@，处理完成", activityType);
            // 解析扩展返回的临时数据（如支付已发起）
          
        } else if (error) {
            NSLog(@"扩展调用失败：%@", error.localizedDescription);
        } else {
            NSLog(@"用户取消了操作");
        }
    };
    // 8. 展示应用选择器
    [[self getCurrentWindowRootVC] presentViewController:activityVC animated:YES completion:nil];
}
- (void)showAlert{
    UIAlertController *alert = [UIAlertController alertControllerWithTitle:@"没有输入参数"
                                                                   message:@"请先输入FPS支付参数"
                                                            preferredStyle:UIAlertControllerStyleAlert];
    
    [alert addAction:[UIAlertAction actionWithTitle:@"确定"
                                               style:UIAlertActionStyleCancel
                                             handler:nil]];
    [[self getCurrentWindowRootVC] presentViewController:alert animated:YES completion:nil];
}
#pragma mark - 解析连接中的查询参数
- (void)parseQueryParamsFromCallbackURL:(NSURL *)url {
    NSURLComponents *components = [NSURLComponents componentsWithURL:url resolvingAgainstBaseURL:NO];
    NSArray<NSURLQueryItem *> *queryItems = components.queryItems;
    
    NSMutableDictionary *params = [NSMutableDictionary dictionary];
    for (NSURLQueryItem *item in queryItems) {
        if (item.value) {
            params[item.name] = item.value;
        }
    }
    [self fpsPaymentResult: [params copy]];
}

@end
