//
//  BaseViewController.m
//  FPSElement
//
//  Created by 周刚 on 2025/11/18.
//

#import "BaseViewController.h"
#import "AppCallViewController.h"
#import "H5CallViewController.h"
@interface BaseViewController ()

@end

@implementation BaseViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = @"FPS Demo";
    self.view.backgroundColor = [UIColor whiteColor];
    // Do any additional setup after loading the view.
    UIButton *appCallButton = [UIButton buttonWithType:UIButtonTypeCustom];
    appCallButton.backgroundColor = [UIColor systemBlueColor];
    appCallButton.frame = CGRectMake(30, 200, 150, 150);
    appCallButton.layer.cornerRadius = 75;
    appCallButton.layer.masksToBounds = YES;
    [appCallButton setTitle:@"原生触发支付" forState:UIControlStateNormal];
    [appCallButton addTarget:self action:@selector(appCallAction) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:appCallButton];
    
    UIButton *h5CallButton = [UIButton buttonWithType:UIButtonTypeCustom];
    h5CallButton.backgroundColor = [UIColor systemBlueColor];
    h5CallButton.frame = CGRectMake(CGRectGetWidth(self.view.frame) - 30 - 150, 200, 150, 150);
    h5CallButton.layer.cornerRadius = 75;
    h5CallButton.layer.masksToBounds = YES;
    [h5CallButton setTitle:@"H5触发支付" forState:UIControlStateNormal];
    [h5CallButton addTarget:self action:@selector(h5CallAction) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:h5CallButton];
}

- (void)appCallAction{
    AppCallViewController *appCallVC = [[AppCallViewController alloc] init];
    [self.navigationController pushViewController:appCallVC animated:YES];
    
}
- (void)h5CallAction{
    H5CallViewController *h5CallVC = [[H5CallViewController alloc] init];
    [self.navigationController pushViewController:h5CallVC animated:YES];
}
/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
