//
//  ViewController.m
//  element
//
//  Created by 周刚 on 2024/9/3.
//

#import "AppCallViewController.h"
#import "FPSAppCallAppTool.h"
#import "define.h"
@interface AppCallViewController ()
@property(nonatomic, assign) UITextView *urlTextView;
@property(nonatomic, assign) UIButton *payButton;
@end

@implementation AppCallViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    self.title = @"原生触发支付";
    self.view.backgroundColor = [UIColor whiteColor];
    UILabel *label = [[UILabel alloc] initWithFrame:CGRectMake(10, 100, CGRectGetWidth(self.view.frame) - 20, 40)];
    label.text = @"测试链接:";
    [self.view addSubview:label];
    
    UIButton *clearButton = [UIButton buttonWithType:UIButtonTypeCustom];
    clearButton.backgroundColor = [UIColor systemOrangeColor];
    clearButton.frame = CGRectMake(CGRectGetWidth(self.view.frame) - 15 - 150, CGRectGetMinY(label.frame), 150, 40);
    clearButton.layer.cornerRadius = 6;
    clearButton.layer.masksToBounds = YES;
    [clearButton setTitle:@"清空" forState:UIControlStateNormal];
    [clearButton addTarget:self action:@selector(clearAction) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:clearButton];
    
    UITextView *textView = [[UITextView alloc] initWithFrame:CGRectMake(10, CGRectGetMaxY(label.frame) + 10, CGRectGetWidth(self.view.frame) - 20, 150)];
    textView.backgroundColor = [UIColor lightGrayColor];
    textView.textColor = [UIColor blueColor];
    textView.text = @"https://fps.qfpay.global/trade/v1/urltranslate/PAYCORE_SHORT_URL_202511075370911194";
    [self.view addSubview:textView];
    self.urlTextView = textView;
    
    UIButton *startButton = [UIButton buttonWithType:UIButtonTypeCustom];
    startButton.backgroundColor = [UIColor systemBlueColor];
    startButton.frame = CGRectMake(15, CGRectGetMaxY(textView.frame) + 32, CGRectGetWidth(self.view.frame) - 30, 44);
    startButton.layer.cornerRadius = 6;
    startButton.layer.masksToBounds = YES;
    [startButton setTitle:@"付款" forState:UIControlStateNormal];
    [startButton addTarget:self action:@selector(startPay:) forControlEvents:UIControlEventTouchUpInside];
    self.payButton = startButton;
    [self.view addSubview:startButton];
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(fpsPaymentResult:) name:kNotificationNameFPSPaymentH5CallAppResult object:nil];
}
- (void)fpsPaymentResult:(NSNotification *)notification {
    NSLog(@"%@", notification.object);
    NSString *params = nil;
    NSString *ret = notification.object[@"is_successful"];
    if ([ret intValue] == 0) {
        params = @"支付失败";
    }else{
        params = @"支付成功";
    }
    UIAlertController *alert = [UIAlertController alertControllerWithTitle:@"提示"
                                                                       message:params
                                                                preferredStyle:UIAlertControllerStyleAlert];
    [alert addAction:[UIAlertAction actionWithTitle:@"确定"
                                               style:UIAlertActionStyleDefault
                                             handler:^(UIAlertAction * _Nonnull action) {
    }]];
    
    [self presentViewController:alert animated:YES completion:nil];
}
- (void)startPay:(UIButton *)btn{
    NSLog(@"asdfasdf");
    [[FPSAppCallAppTool shareInstance] invokePaymentExtension:self.urlTextView.text];
}
- (void)clearAction{
    self.urlTextView.text = @"";
}
- (void)dealloc{
    [[NSNotificationCenter defaultCenter] removeObserver:self name:kNotificationNameFPSPaymentH5CallAppResult object:nil];
}
@end
